%Test the method make_interactive_choices
function test_suite = testMakeInteractiveChoices %#ok<*STOUT>
initTestSuite;

function self = setup
self.poly_system = BertiniLab;
self.default_name = 'interactive_choices';
self.user_name = 'ic';
warning('off','MATLAB:DELETE:FileNotFound')
delete(self.default_name,self.user_name)
warning('on','MATLAB:DELETE:FileNotFound')


function testEmptyChoice(self) %#ok<*DEFNU>
s = self.poly_system.make_interactive_choices;
assert(isempty(s))

function testNameArgEmptyChoice(self)
s = self.poly_system.make_interactive_choices;
assert(isempty(s))

function testNotCell(self)
self.poly_system.interactive_choices = 0;
f = @() self.poly_system.make_interactive_choices;
assertExceptionThrown(f,'MATLAB:cellfun:NotACell')

function testDefaultName(self)
self.poly_system.interactive_choices = {0};
s = self.poly_system.make_interactive_choices;
fname = self.default_name;
assertEqual(s,['< ',fullfile(pwd,fname)])
assert(exist(fname,'file')==2)
fid = fopen(fname);
n = fscanf(fid,'%d\n');
fclose(fid);
assertEqual(n,0)

function testNameArg(self)
fname = self.user_name;
self.poly_system.interactive_choices = {0};
s = self.poly_system.make_interactive_choices(fname);
assertEqual(s,['< ',fullfile(pwd,fname)])
assert(exist(fname,'file')==2)
fid = fopen(fname);
n = fscanf(fid,'%d\n');
fclose(fid);
assertEqual(n,0)

function teardown(self)
warning('off','MATLAB:DELETE:FileNotFound')
delete(self.default_name,self.user_name)
warning('on','MATLAB:DELETE:FileNotFound')
